#ifndef _VZero_h_
#define _VZero_h_

#include "DataFormats/TrackReco/interface/VZeroFwd.h"

#include "Geometry/Vector/interface/GlobalVector.h"

namespace reco {
  class VZero
  {
   public:
     // default construction
     VZero() { }

     // constructor from parameters
     VZero(float impactPositiveDaughter,
           float impactNegativeDaughter,
           float dcaR,
           float dcaZ,
           GlobalVector creationPoint,
           GlobalVector momentumPositiveDaughter,
           GlobalVector momentumNegativeDaughter,
           float impactMother,
           float armenterosPt,
           float armenterosAlpha);

     float impactPositiveDaughter() const { return impactPositiveDaughter_; }
     float impactNegativeDaughter() const { return impactNegativeDaughter_; }
     float dcaR() const { return dcaR_; }
     float dcaZ() const { return dcaZ_; }
     GlobalVector creationPoint() const { return creationPoint_; }
     GlobalVector momentumPositiveDaughter() const
         { return momentumPositiveDaughter_; }
     GlobalVector momentumNegativeDaughter() const
         { return momentumNegativeDaughter_; }
     float impactMother() const { return impactMother_; }
     float armenterosPt() const { return armenterosPt_; }
     float armenterosAlpha() const { return armenterosAlpha_; }

   private:
     float impactPositiveDaughter_;
     float impactNegativeDaughter_;
     float dcaR_;
     float dcaZ_;
     GlobalVector creationPoint_;
     GlobalVector momentumPositiveDaughter_;
     GlobalVector momentumNegativeDaughter_;
     float impactMother_;
     float armenterosPt_;
     float armenterosAlpha_;
  }; 
}

#endif
